/*
 * Decompiled with CFR 0.152.
 */
package it.randomtower.engine.tween;

import it.randomtower.engine.entity.Entity;
import it.randomtower.engine.tween.Tween;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.Log;

public class Tweener {
    public int MODE_DELETE = 0;
    private List<Tween> tweens = new ArrayList<Tween>();
    private int current = -1;
    private int mode = 0;

    public Tweener(Tween ... tweens) {
        if (tweens != null) {
            this.tweens.addAll(Arrays.asList(tweens));
            this.current = this.tweens.size() - 1;
        }
    }

    public boolean add(Tween tween) {
        if (tween != null) {
            boolean result = this.tweens.add(tween);
            if (this.current <= 0) {
                this.current = this.tweens.size() - 1;
            }
            return result;
        }
        return false;
    }

    public Vector2f apply(Entity parent) {
        if (!this.tweens.isEmpty() && this.tweens.get(this.current) != null) {
            Vector2f value = this.tweens.get(this.current).apply(parent);
            if (value == null && this.mode == 0) {
                this.tweens.remove(this.current);
                this.current = this.tweens.size() - 1;
                if (this.current >= 0) {
                    this.tweens.get(this.current).setStartPosition(parent.previousx, parent.previousy);
                }
                Log.debug("Current Tweener size: " + this.tweens.size());
            }
            return value;
        }
        return null;
    }

    public void start() {
        if (!this.tweens.isEmpty() && this.tweens.get(this.current) != null) {
            this.tweens.get(this.current).start();
        }
    }

    public void pause() {
        if (!this.tweens.isEmpty() && this.tweens.get(this.current) != null) {
            this.tweens.get(this.current).pause();
        }
    }

    public Vector2f reset() {
        if (!this.tweens.isEmpty() && this.tweens.get(this.current) != null) {
            return this.tweens.get(this.current).reset();
        }
        return null;
    }
}

