/*
 * Decompiled with CFR 0.152.
 */
package it.randomtower.engine.tween;

import it.randomtower.engine.entity.Entity;
import it.randomtower.engine.tween.Motion;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.Log;

public class Tween {
    private Motion motion;
    private boolean active = true;
    private Vector2f startingPosition;

    public Tween(Motion motion) {
        this(motion, true);
    }

    public Tween(Motion motion, boolean active) {
        this.motion = motion;
        this.active = active;
    }

    public Vector2f apply(Entity parent) {
        if (this.active && !this.motion.completed) {
            if (this.startingPosition == null) {
                this.startingPosition = new Vector2f(parent.x, parent.y);
            }
            Vector2f result = this.motion.update();
            Log.debug("move to :" + result.toString());
            return result;
        }
        this.active = false;
        return null;
    }

    public void start() {
        this.active = true;
    }

    public void pause() {
        this.active = false;
    }

    public Vector2f reset() {
        if (this.startingPosition != null) {
            this.active = false;
            return this.startingPosition;
        }
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setStartPosition(float x, float y) {
        this.startingPosition = new Vector2f(x, y);
        this.motion.fromX = x;
        this.motion.fromY = y;
    }
}

