/*
 * Decompiled with CFR 0.152.
 */
package it.randomtower.engine.tween;

import it.randomtower.engine.tween.Ease;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.Log;

public abstract class Motion {
    public float fromX;
    public float fromY;
    public float toX;
    public float toY;
    protected int duration;
    protected float lastX;
    protected float lastY;
    protected float timer;
    protected float t;
    public boolean completed;
    protected int easeFunction = -1;

    public Motion(float fromX, float fromY, float toX, float toY, int duration, int easeFunction) {
        this.fromX = fromX;
        this.fromY = fromY;
        this.toX = toX;
        this.toY = toY;
        this.duration = duration;
        this.lastX = fromX;
        this.lastY = fromY;
        this.completed = false;
        this.easeFunction = easeFunction;
    }

    public Vector2f update() {
        this.timer += 1.0f;
        this.t = this.timer / (float)this.duration;
        if (this.easeFunction > -1) {
            this.t = this.ease(this.t);
        }
        if (this.lastX == this.toX && this.lastY == this.toY) {
            this.completed = true;
            this.timer = 0.0f;
            return new Vector2f(this.toX, this.toY);
        }
        return new Vector2f();
    }

    private float ease(float t) {
        switch (this.easeFunction) {
            case 0: {
                return Ease.quadIn(t);
            }
            case 1: {
                return Ease.quadOut(t);
            }
            case 2: {
                return Ease.quadInOut(t);
            }
            case 3: {
                return Ease.cubeIn(t);
            }
            case 4: {
                return Ease.cubeOut(t);
            }
            case 5: {
                return Ease.cubeInOut(t);
            }
            case 6: {
                return Ease.quartIn(t);
            }
            case 7: {
                return Ease.quartOut(t);
            }
            case 8: {
                return Ease.quartInOut(t);
            }
            case 9: {
                return Ease.quintIn(t);
            }
            case 10: {
                return Ease.quintOut(t);
            }
            case 11: {
                return Ease.quintInOut(t);
            }
            case 12: {
                return Ease.sineIn(t);
            }
            case 13: {
                return Ease.sineOut(t);
            }
            case 14: {
                return Ease.sineInOut(t);
            }
            case 15: {
                return Ease.bounceIn(t);
            }
            case 16: {
                return Ease.bounceOut(t);
            }
            case 17: {
                return Ease.bounceInOut(t);
            }
            case 18: {
                return Ease.circIn(t);
            }
            case 19: {
                return Ease.circOut(t);
            }
            case 20: {
                return Ease.circInOut(t);
            }
            case 21: {
                return Ease.expoIn(t);
            }
            case 22: {
                return Ease.expoOut(t);
            }
            case 23: {
                return Ease.expoInOut(t);
            }
            case 24: {
                return Ease.backIn(t);
            }
            case 25: {
                return Ease.backOut(t);
            }
            case 26: {
                return Ease.backInOut(t);
            }
        }
        Log.warn("Easing function not mapped " + this.easeFunction);
        return 0.0f;
    }
}

