/*
 * Decompiled with CFR 0.152.
 */
package it.randomtower.engine.entity;

import it.randomtower.engine.entity.Entity;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;

public class TextEntity
extends Entity {
    private Font font = null;
    private String text = null;

    public TextEntity(float x, float y, Font font, String text) {
        super(x, y);
        this.font = font;
        this.setText(text);
    }

    @Override
    public void render(GameContainer container, Graphics g) throws SlickException {
        if (this.font == null) {
            this.font = container.getDefaultFont();
            this.calculateHitBox();
        }
        g.setFont(this.font);
        if (this.text != null) {
            g.drawString(this.text, this.x, this.y);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.calculateHitBox();
    }

    private void calculateHitBox() {
        if (this.font != null && this.text != null) {
            int w = this.font.getWidth(this.text);
            int h = this.font.getHeight(this.text);
            this.setHitBox(0.0f, 0.0f, w, h);
        }
    }
}

