/*
 * Decompiled with CFR 0.152.
 */
package it.randomtower.engine.entity;

public class Alarm {
    private String name;
    private boolean active = false;
    private int triggerTime;
    private int counter = 0;
    private boolean oneShotAlaram = true;
    private boolean dead = false;
    private boolean useDelta = false;

    public Alarm(String name, int triggerTime, boolean oneShot) {
        this(name, triggerTime, oneShot, false);
    }

    public Alarm(String name, int triggerTime, boolean oneShot, boolean useDelta) {
        this.name = name;
        this.triggerTime = triggerTime;
        this.counter = 0;
        this.oneShotAlaram = oneShot;
        this.active = false;
    }

    public void start() {
        this.counter = this.counter >= this.triggerTime ? (this.counter -= this.triggerTime) : 0;
        this.active = true;
    }

    public void pause() {
        this.active = false;
    }

    public void resume() {
        this.active = true;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean update(int delta) {
        this.counter = this.useDelta ? (this.counter += delta) : ++this.counter;
        return this.counter >= this.triggerTime;
    }

    public String getName() {
        return this.name;
    }

    public int getTriggerTime() {
        return this.triggerTime;
    }

    public int getCounter() {
        return this.counter;
    }

    public boolean isOneShotAlaram() {
        return this.oneShotAlaram;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
    }
}

