/*
 * Decompiled with CFR 0.152.
 */
package it.randomtower.engine.actors;

import it.randomtower.engine.ME;
import it.randomtower.engine.entity.Entity;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Vector2f;

public class TopDownActor
extends Entity {
    public static final String NAME = "player";
    private static final int HEIGHT = 28;
    private static final int WIDTH = 23;
    public static final String STAND_DOWN = "stand_down";
    public static final String STAND_UP = "stand_up";
    public static final String STAND_RIGHT = "stand_right";
    public static final String STAND_LEFT = "stand_left";
    public Vector2f mySpeed = new Vector2f(2.0f, 2.0f);
    public boolean attacking = false;

    public TopDownActor(float x, float y, String ref) {
        super(x, y);
        this.name = NAME;
        if (ref != null) {
            this.setupAnimations(ref);
        }
        this.depth = ME.Z_LEVEL_TOP;
        this.defineControls();
        this.setHitBox(0.0f, 0.0f, 23, 28);
        this.addType(NAME);
    }

    private void defineControls() {
        this.define("walk_Up", 200, 17);
        this.define("walk_Down", 208, 31);
        this.define("walk_Left", 203, 30);
        this.define("walk_Right", 205, 32);
    }

    public void setupAnimations(String ref) {
        try {
            this.setGraphic(new SpriteSheet(ref, 23, 28));
            this.duration = 150;
            this.addAnimation(STAND_DOWN, false, 0, 0);
            this.addAnimation("walk_Down", true, 0, 0, 1, 2, 3, 4, 5, 6, 7);
            this.addAnimation("walk_Up", true, 1, 0, 1, 2, 3, 4, 5, 6, 7);
            this.addAnimation("walk_Right", true, 2, 0, 1, 2, 3, 4, 5);
            this.addAnimation("walk_Left", true, 3, 0, 1, 2, 3, 4, 5);
            this.addAnimation(STAND_UP, false, 1, 0);
            this.addAnimation(STAND_RIGHT, false, 2, 0);
            this.addAnimation(STAND_LEFT, false, 3, 0);
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(GameContainer container, int delta) throws SlickException {
        super.update(container, delta);
        this.updateMovements();
    }

    private void updateMovements() {
        boolean horizontalMovement = true;
        boolean verticalMovement = true;
        if (this.check("walk_Up")) {
            this.currentAnim = "walk_Up";
            this.moveUp();
        } else if (this.check("walk_Down")) {
            this.currentAnim = "walk_Down";
            this.moveDown();
        } else {
            verticalMovement = false;
        }
        if (this.check("walk_Right")) {
            this.currentAnim = "walk_Right";
            this.moveRight();
        } else if (this.check("walk_Left")) {
            this.currentAnim = "walk_Left";
            this.moveLeft();
        } else {
            horizontalMovement = false;
        }
        if (!horizontalMovement && !verticalMovement) {
            if (this.currentAnim.equalsIgnoreCase("walk_Down")) {
                this.currentAnim = STAND_DOWN;
            } else if (this.currentAnim.equalsIgnoreCase("walk_Up")) {
                this.currentAnim = STAND_UP;
            } else if (this.currentAnim.equalsIgnoreCase("walk_Right")) {
                this.currentAnim = STAND_RIGHT;
            } else if (this.currentAnim.equalsIgnoreCase("walk_Left")) {
                this.currentAnim = STAND_LEFT;
            }
        }
    }

    public void moveLeft() {
        if (this.collide("Solid", this.x - this.mySpeed.x, this.y) == null) {
            this.x -= this.mySpeed.x;
        }
    }

    public void moveRight() {
        if (this.collide("Solid", this.x + this.mySpeed.x, this.y) == null) {
            this.x += this.mySpeed.x;
        }
    }

    public void moveDown() {
        if (this.collide("Solid", this.x, this.y + this.mySpeed.y) == null) {
            this.y += this.mySpeed.y;
        }
    }

    public void moveUp() {
        if (this.collide("Solid", this.x, this.y - this.mySpeed.y) == null) {
            this.y -= this.mySpeed.y;
        }
    }

    @Override
    public void render(GameContainer container, Graphics g) throws SlickException {
        super.render(container, g);
    }

    public boolean isRightMoving() {
        return this.currentAnim.equalsIgnoreCase("walk_Right");
    }

    public boolean isLeftMoving() {
        return this.currentAnim.equalsIgnoreCase("walk_Left");
    }

    public boolean isUpMoving() {
        return this.currentAnim.equalsIgnoreCase("walk_Up");
    }

    public boolean isDownMoving() {
        return this.currentAnim.equalsIgnoreCase("walk_Down");
    }

    public boolean isRightStanding() {
        return this.currentAnim.equalsIgnoreCase(STAND_RIGHT);
    }

    public boolean isLeftStanding() {
        return this.currentAnim.equalsIgnoreCase(STAND_LEFT);
    }

    public boolean isUpStanding() {
        return this.currentAnim.equalsIgnoreCase(STAND_UP);
    }

    public boolean isDownStanding() {
        return this.currentAnim.equalsIgnoreCase(STAND_DOWN);
    }
}

