/*
 * Decompiled with CFR 0.152.
 */
package it.randomtower.engine.actors;

import it.randomtower.engine.entity.Entity;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;

public class StaticActor
extends Entity {
    public static final String NAME = "STATIC_ACTOR";

    public StaticActor(float x, float y, int width, int height, String image) {
        super(x, y);
        this.name = NAME;
        this.width = width;
        this.height = height;
        this.setHitBox(0.0f, 0.0f, width, height);
        this.addType(NAME, "Solid");
        this.setupGraphic(image);
    }

    public StaticActor(float x, float y, int width, int height, String ref, int row, int frame) {
        this(x, y, width, height, "");
        this.setupAnimations(ref, row, frame);
    }

    public StaticActor(float x, float y, int width, int height, Image image) {
        this(x, y, width, height, "");
        this.setGraphic(image);
    }

    private void setupGraphic(String ref) {
        if (ref == null || ref.length() == 0) {
            return;
        }
        try {
            this.setGraphic(new Image(ref));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupAnimations(String ref, int row, int frame) {
        try {
            this.setGraphic(new SpriteSheet(ref, this.width, this.height));
            this.addAnimation(NAME, false, row, frame);
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }
}

