/*
 * Decompiled with CFR 0.152.
 */
package it.randomtower.engine;

import it.randomtower.engine.Camera;
import it.randomtower.engine.ME;
import it.randomtower.engine.actors.StaticActor;
import it.randomtower.engine.entity.Entity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.tiled.TiledMap;
import org.newdawn.slick.util.Log;

public class World
extends BasicGameState {
    public GameContainer container = null;
    public int id = 0;
    public int width = 0;
    public int height = 0;
    private List<Entity> entities = new ArrayList<Entity>();
    private List<Entity> removable = new ArrayList<Entity>();
    private List<Entity> addable = new ArrayList<Entity>();
    public Camera camera;

    public World(int id) {
        this.id = id;
    }

    public World(int id, GameContainer container) {
        this.id = id;
        this.container = container;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.container = container;
        this.width = container.getWidth();
        this.height = container.getHeight();
    }

    @Override
    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        ME.world = this;
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        if (this.camera != null) {
            g.translate(this.camera.x, this.camera.y);
        }
        for (Entity e : this.entities) {
            if (ME.debugEnabled) {
                g.setColor(ME.borderColor);
                Rectangle hitBox = new Rectangle(e.x + e.hitboxOffsetX, e.y + e.hitboxOffsetY, e.width, e.height);
                g.draw(hitBox);
                g.setColor(Color.white);
            }
            if (this.camera != null) {
                e.render(container, g);
                continue;
            }
            e.render(container, g);
        }
        if (this.camera != null) {
            g.translate(-this.camera.x, -this.camera.y);
        }
        ME.render(container, game, g);
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (container == null) {
            throw new SlickException("no container set");
        }
        ME.delta = delta;
        this.removable.clear();
        if (this.addable.size() > 0) {
            for (Entity entity : this.addable) {
                this.entities.add(entity);
                entity.addedToWorld();
            }
            this.addable.clear();
            Collections.sort(this.entities);
        }
        for (Entity e : this.entities) {
            e.updateAlarms(delta);
            e.update(container, delta);
            e.checkWorldBoundaries();
        }
        for (Entity entity : this.removable) {
            this.entities.remove(entity);
            entity.removedFromWorld();
        }
        if (this.camera != null) {
            this.camera.update(container, delta);
        }
        ME.update(container, game, delta);
    }

    @Override
    public int getID() {
        return this.id;
    }

    public void add(Entity e) {
        e.setWorld(this);
        this.addable.add(e);
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public int getNrOfEntities(String type) {
        if (this.entities.size() > 0) {
            int number = 0;
            for (Entity entity : this.entities) {
                if (!entity.getType().contains(type)) continue;
                ++number;
            }
            return number;
        }
        return 0;
    }

    public boolean remove(Entity entity) {
        if (!this.removable.contains(entity)) {
            return this.removable.add(entity);
        }
        return false;
    }

    public Entity find(String name) {
        if (name == null) {
            return null;
        }
        for (Entity entity : this.entities) {
            if (entity.name == null || !entity.name.equalsIgnoreCase(name)) continue;
            return entity;
        }
        return null;
    }

    public void clear() {
        for (Entity entity : this.entities) {
            entity.removedFromWorld();
        }
        this.entities.clear();
        this.addable.clear();
        this.removable.clear();
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void setCameraOn(Entity entity) {
        this.camera = new Camera(entity, this.container.getWidth(), this.container.getHeight());
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void loadEntityFromMap(TiledMap map) {
        if (map == null) {
            Log.error("unable to load map information");
            return;
        }
        int layerIndex = -1;
        for (int l = 0; l < map.getLayerCount(); ++l) {
            String value = map.getLayerProperty(l, "type", null);
            if (value == null || !value.equalsIgnoreCase("entity")) continue;
            layerIndex = l;
            break;
        }
        if (layerIndex != -1) {
            Log.debug("Entity layer found on map");
            for (int w = 0; w < map.getWidth(); ++w) {
                for (int h = 0; h < map.getHeight(); ++h) {
                    Image img = map.getTileImage(w, h, layerIndex);
                    if (img == null) continue;
                    StaticActor te = new StaticActor((float)(w * img.getWidth()), (float)(h * img.getHeight()), img.getWidth(), img.getHeight(), img);
                    this.add(te);
                }
            }
        }
    }
}

