/*
 * Decompiled with CFR 0.152.
 */
package it.randomtower.engine;

import it.randomtower.engine.State;
import java.util.Collections;
import java.util.LinkedList;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

public class StateManager {
    private LinkedList<State> states = new LinkedList();
    private State currentState;

    public void add(State s) {
        this.states.add(s);
        if (this.currentState == null) {
            this.currentState = s;
            this.currentState.init();
        }
    }

    public void addAll(State ... st) {
        if (st != null && st.length > 0) {
            Collections.addAll(this.states, st);
            if (this.currentState == null) {
                this.currentState = st[0];
                this.currentState.init();
            }
        }
    }

    public void enter(Class<?> c) {
        for (State s : this.states) {
            if (!s.getClass().getCanonicalName().equalsIgnoreCase(c.getCanonicalName())) continue;
            this.currentState = s;
            this.currentState.init();
            return;
        }
    }

    public Object currentState() {
        return this.currentState;
    }

    public void update(GameContainer container, int delta) {
        this.currentState.update(container, delta);
    }

    public void render(Graphics g) {
        this.currentState.render(g);
    }
}

