/*
 * Decompiled with CFR 0.152.
 */
package it.randomtower.engine;

import it.randomtower.engine.World;
import it.randomtower.engine.entity.Entity;
import java.util.Hashtable;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.RoundedRectangle;
import org.newdawn.slick.state.StateBasedGame;

public class ME {
    public static boolean debugEnabled = false;
    public static int keyToggleDebug = -1;
    public static Color borderColor = Color.red;
    public static int keyRestart = -1;
    public static float scaleX = 1.0f;
    public static float scaleY = 1.0f;
    public static final Integer Z_LEVEL_TOP = 100;
    public static final String WALK_LEFT = "walk_Left";
    public static final String WALK_RIGHT = "walk_Right";
    public static final String WALK_UP = "walk_Up";
    public static final String WALK_DOWN = "walk_Down";
    public static Hashtable<String, Object> attributes = new Hashtable();
    public static World world;
    public static int delta;

    public static void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (container == null) {
            throw new SlickException("no container set");
        }
        if (world == null) {
            throw new SlickException("no world set");
        }
        if (keyToggleDebug != -1 && container.getInput().isKeyPressed(keyToggleDebug)) {
            boolean bl = debugEnabled = !debugEnabled;
        }
        if (keyRestart != -1 && container.getInput().isKeyPressed(keyRestart)) {
            world.clear();
        }
    }

    public static void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        if (container == null) {
            throw new SlickException("no container set");
        }
        if (world == null) {
            throw new SlickException("no world set");
        }
        if (scaleX != 1.0f || scaleY != 1.0f) {
            g.scale(scaleX, scaleY);
        }
        if (debugEnabled) {
            RoundedRectangle r = new RoundedRectangle(1.0f, 1.0f, container.getWidth() - 1, 40.0f, 20.0f);
            Color c = Color.lightGray;
            c.a = 0.3f;
            g.setColor(c);
            g.fill(r);
            g.draw(r);
            g.setColor(Color.white);
            g.drawString("Entities: " + world.getEntities().size(), container.getWidth() - 130, 10.0f);
            container.setShowFPS(true);
        } else {
            container.setShowFPS(false);
        }
    }

    public static void scale(float sx, float sy) {
        scaleX = sx;
        scaleY = sy;
    }

    public static void remove(Entity entity) {
        if (world != null) {
            world.remove(entity);
        }
    }
}

