/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Item;
import game.Pause;
import game.Schuss;
import game.Ufo;
import it.randomtower.engine.ME;
import it.randomtower.engine.ResourceManager;
import it.randomtower.engine.entity.Entity;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;

public class Player
extends Entity {
    public static String SHIP = "ship";
    private final String[] enemies = new String[]{Ufo.UFO};
    private final String[] items = new String[]{Item.ITEM};
    private Image player;
    private static String name;
    private int deathcount;
    private int savetime = this.deathcount = 0;
    private int fireRate = 130;
    private int milliCount = 0;
    private int millis = this.fireRate;
    private int milliStep = this.millis / 5;
    private static int schiff;
    private static int stufe;
    private static int punkte;
    private static int health;
    private static int kills;
    private static int multimulti;
    private static int killstotal;
    private static double multiplikator;
    public static double speed;
    private static boolean pause;
    private static boolean level2;
    private static boolean level5;
    private static boolean level7;
    private static boolean level10;

    static {
        stufe = 0;
        punkte = 0;
        health = 10;
        kills = 0;
        multimulti = 8;
        killstotal = 0;
        multiplikator = 1.0;
        speed = 0.17;
        pause = false;
        level2 = false;
        level5 = false;
        level7 = false;
        level10 = false;
    }

    public Player(float x, float y) throws IOException {
        super(x, y);
        this.x = x;
        this.y = y;
        FileReader fr = new FileReader("res/saves/Aktuell.txt");
        BufferedReader br = new BufferedReader(fr);
        schiff = Integer.parseInt(br.readLine().toString());
        name = br.readLine();
        br.close();
        if (schiff == 0) {
            this.player = ResourceManager.getImage("schiffI");
            this.setHitBox(10.0f, 15.0f, 140, 65);
            speed = 0.17;
        } else if (schiff == 1) {
            this.player = ResourceManager.getImage("schiffII");
            this.setHitBox(10.0f, 15.0f, 170, 100);
            speed = 0.2;
            this.fireRate = 120;
        }
        this.setGraphic(this.player);
        this.addType(SHIP);
        this.define("up", 200, 17);
        this.define("down", 208, 31);
        this.define("left", 203, 30);
        this.define("right", 205, 32);
        this.define("fire", 57);
        this.define("die", 25);
    }

    @Override
    public void update(GameContainer gc, int delta) throws SlickException {
        super.update(gc, delta);
        Input input = gc.getInput();
        if (input.isKeyPressed(1)) {
            if (!pause) {
                Pause.pause(true);
            } else {
                Pause.pause(false);
            }
        }
        if (!pause) {
            if (this.check("die")) {
                health = 0;
            }
            if (this.check("up") && this.y > 0.0f) {
                this.y = (float)((double)this.y - speed * (double)delta);
            }
            if (this.check("down") && this.y + (float)this.player.getHeight() < (float)(this.world.height - 40)) {
                this.y = (float)((double)this.y + speed * (double)delta);
            }
            if (this.check("right") && this.x + (float)this.player.getWidth() < (float)this.world.width) {
                this.x = (float)((double)this.x + speed * (double)delta);
            }
            if (this.check("left") && this.x > 0.0f) {
                this.x = (float)((double)this.x - speed * (double)delta);
            }
            if (this.check("fire")) {
                this.milliCount += delta;
                while (this.milliCount > this.milliStep) {
                    this.milliCount -= this.milliStep;
                    this.millis -= this.milliStep;
                }
                if (this.millis <= 0) {
                    Schuss schuss = new Schuss(this.x + 144.0f, this.y + 36.0f);
                    ME.world.add(schuss);
                    this.millis = this.fireRate;
                }
            }
        }
        if (this.collide(this.enemies, this.x, this.y) != null) {
            this.x = 0.0f;
            this.y = 230.0f;
            --health;
            kills = 0;
        }
        if (this.collide(this.items, this.x, this.y) != null) {
            punkte = (int)((double)punkte + 100.0 * multiplikator);
        }
        if ((double)(kills + 1) % ((double)multimulti * multiplikator) == 0.0) {
            multimulti *= 2;
            multiplikator += 0.5;
        }
        if (kills <= 0) {
            multimulti = 8;
            multiplikator = 1.0;
        }
        if (stufe == 2 && !level2) {
            speed += 0.04;
            level2 = true;
        }
        if (stufe == 5 && !level5) {
            this.fireRate -= 10;
            level5 = true;
        }
        if (stufe == 7 && !level7) {
            this.fireRate -= 20;
            level7 = true;
        }
        if (stufe == 10 && !level10) {
            this.fireRate -= 10;
            level10 = true;
        }
    }

    public static String getName() {
        return name;
    }

    public static int getSchiff() {
        return schiff;
    }

    public static void setSchiff(int schiff) {
        Player.schiff = schiff;
    }

    public static double getMultiplikator() {
        return multiplikator;
    }

    public static int getKills() {
        return kills;
    }

    public static void setKills(int kills) {
        Player.kills = kills;
    }

    public static int getKillstotal() {
        return killstotal;
    }

    public static void setKillstotal(int kills) {
        killstotal = kills;
    }

    public static int getStufe() {
        return stufe;
    }

    public static void setStufe(int stufe) {
        Player.stufe = stufe;
    }

    public static int getPunkte() {
        return punkte;
    }

    public static void setPunkte(int punkte) {
        Player.punkte = punkte;
    }

    public static int getHealth() {
        return health;
    }

    public static void setHealth(int health) {
        Player.health = health;
    }

    public static void pause(boolean uebergabe) {
        pause = uebergabe;
    }
}

